// NeoPixel Ring simple sketch (c) 2013 Shae Erisson
// Released under the GPLv3 license to match the rest of the
// Adafruit NeoPixel library

#include <Adafruit_NeoPixel.h>
#include <arduino-timer.h>
#include <Buzzer.h>

// Which pin on the Arduino is connected to the NeoPixels?
#define NEOPIXEL_PIN        6 // On Trinket or Gemma, suggest changing this to 1
#define LIFT_PIN1 9
#define LIFT_PIN2 10
#define BUMPER_PIN 7
#define START_PIN 3
#define BUMPER_LED_PIN 4

// How many NeoPixels are attached to the Arduino?
#define PIT_PIXEL_START 0
#define PIT_PIXEL_END 4
#define CLOCK_PIXEL_START 4
#define CLOCK_PIXEL_END 34
#define ARENA_PIXEL_START 34
#define ARENA_PIXEL_END 91 // Popular NeoPixel ring size



// When setting up the NeoPixel library, we tell it how many pixels,
// and which pin to use to send signals. Note that for older NeoPixel
// strips you might need to change the third parameter -- see the
// strandtest example for more information on possible values.
Adafruit_NeoPixel pixels(ARENA_PIXEL_END, NEOPIXEL_PIN, NEO_GRB + NEO_KHZ800);
Buzzer buzzer(11);

bool not_started = true;
bool pit_not_released = true;
bool release_time = false;
bool pit_dark = false;
int clock = 1;

void nothing() {}

auto timer = timer_create_default(); // create a timer with default settings
auto pit_blink_task = timer.in(240*1000,nothing);
auto pit_task = timer.in(240*1000, nothing);

void setup() {
  pinMode(LIFT_PIN1,OUTPUT);
  pinMode(LIFT_PIN2,OUTPUT);
  pinMode(BUMPER_LED_PIN,OUTPUT);
  pinMode(BUMPER_PIN,INPUT_PULLUP);
  pinMode(START_PIN,INPUT_PULLUP);
  pixels.begin(); // INITIALIZE NeoPixel strip object (REQUIRED)
  pixels.clear(); // Set all pixel colors to 'off'
  pixels.show();
  digitalWrite(BUMPER_LED_PIN,LOW);
  reset_platform();
  arenaWhite();
}

bool led_clock(void *) {
  if (clock==30) {
    for (int i=CLOCK_PIXEL_START; i<CLOCK_PIXEL_END; i++) { // For each pixel...
    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
      pixels.setPixelColor(i, pixels.Color(250, 250, 0));
    }
  } else if (clock==60) {
    for (int i=CLOCK_PIXEL_START; i<CLOCK_PIXEL_END; i++) { // For each pixel...
    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
      pixels.setPixelColor(i, pixels.Color(250, 0, 0));
    }
  } else {
    pixels.setPixelColor(CLOCK_PIXEL_END-(clock % 30), pixels.Color(0, 0, 0));
  }
  pixels.show();
  clock++;
  return true;
}


bool toggle_pit(void *) {
  if (pit_dark) {
    for(int i=PIT_PIXEL_START; i<PIT_PIXEL_END; i++) { // For each pixel...
    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
      pixels.setPixelColor(i, pixels.Color(250, 0, 0));
    }
    pixels.show();
    pit_dark = false;
  }
  else {
    for(int i=PIT_PIXEL_START; i<PIT_PIXEL_END; i++) { // For each pixel...
    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
      pixels.setPixelColor(i, pixels.Color(0, 0, 0));
    }
    pixels.show();
    pit_dark = true;
  }
  return true;
}

void pit_red(void *) {
  timer.cancel(pit_task);
  for(int i=PIT_PIXEL_START; i<PIT_PIXEL_END; i++) { // For each pixel...
    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
    pixels.setPixelColor(i, pixels.Color(250, 0, 0));
  }
  pixels.show();   // Send the updated pixel colors to the hardware.
}

void arenaWhite() {
  for(int i=ARENA_PIXEL_START; i<ARENA_PIXEL_END; i++) { // For each pixel...

    // pixels.Color() takes RGB values, from 0,0,0 up to 255,255,255
    // Here we're using a moderately bright green color:
    pixels.setPixelColor(i, pixels.Color(255, 255, 255));
  }
  pixels.show();   // Send the updated pixel colors to the hardware.
}

void reset_platform() {
  digitalWrite(LIFT_PIN1,HIGH);
  digitalWrite(LIFT_PIN2,LOW);
}

void start() {
  buzzer.begin(100);
  // Rot
  for(int j=0; j<250; j++) {
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(j, 0, 0));
    };
    pixels.show();
    delay(1);
  };
  buzzer.sound(NOTE_D7, 150);
  for(int j=249; j>=0; j--) {
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(j, 0, 0));
    };
    pixels.show();
    delay(1);
  };
  // Gelb
  for(int j=0; j<250; j++) {
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(j, j, 0));
    };
    pixels.show();
    delay(1);
  };
  buzzer.sound(NOTE_D7, 150);
  for(int j=249; j>=0; j--) {
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(j, j, 0));
    };
    pixels.show();
    delay(1);
  };
  // Grün
  for(int j=0; j<250; j++) {
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(0, j, 0));
    };
    pixels.show();
    delay(1);
  };
  buzzer.sound(NOTE_G7, 300);
  arenaWhite();
  timer.in(180000, end_game);
  timer.in(60000, start_pit);
  timer.every(2000, led_clock);
}

void start_pit(void *) { //activate pit button and signal it with flashing LED
  release_time = true;
  timer.cancel(pit_blink_task);
  pit_blink_task = timer.every(900,toggle_led);
}

bool toggle_led(void *) {
  digitalWrite(BUMPER_LED_PIN, !digitalRead(BUMPER_LED_PIN)); // toggle the LED
  return true;
}

void end_game(void *) {
  pixels.clear();
  timer.cancel(); //stop every timer
  for(int j=0; j<2; j++) { //some LED-show
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(250, 0, 0));
    }
    pixels.show();
    buzzer.sound(NOTE_E7, 300);
    delay(200);
    for(int i=CLOCK_PIXEL_START; i<ARENA_PIXEL_END; i++) {
      pixels.setPixelColor(i, pixels.Color(0, 0, 0));
    }
    pixels.show();
    buzzer.sound(NOTE_E7, 300);
    delay(200);
  };
  arenaWhite();
  while (true) { //do nothing more until reset
    delay(1000);
  }
}

void release_pit(void *) { //drops the pi with some LED-show down
  pit_task = timer.every(900,toggle_pit);
  timer.in(6000,pit_red); //makes steady red pit after 6s
  digitalWrite(BUMPER_LED_PIN,LOW); //LED on pitbutton is dark
  digitalWrite(LIFT_PIN1,LOW);
  digitalWrite(LIFT_PIN2,HIGH);
}

void loop() {
  timer.tick();
  delay(5);
  if (digitalRead(START_PIN)==LOW && not_started) {
    not_started = false;
    start();
  }
  if (digitalRead(BUMPER_PIN)==LOW && release_time && pit_not_released) {
    pit_not_released = false;
    timer.cancel(pit_blink_task); //stop blinking
    digitalWrite(BUMPER_LED_PIN,HIGH); //LED on pibutton is bright
    timer.in(5000,release_pit); //release pit after 5s
  };
}
